# Elementor Quiz Spam Protection

Ein WordPress-Plugin, das ein Quiz-Feld zu Elementor Pro Forms hinzufügt als eleganten, DSGVO-konformen Spam-Schutz.

## Features

- **Quiz-basierter Spam-Schutz** - Keine Captchas, keine externen Services
- **DSGVO-konform** - Keine Cookies, keine externen Requests
- **Globale & lokale Fragen** - Einmal definieren, überall nutzen oder pro Formular anpassen
- **Sichere Validierung** - Antworten werden gehasht, Zeitlimit verhindert Replay-Attacken
- **Native Elementor-Integration** - Fühlt sich an wie ein Standard-Feld

## Installation

1. ZIP-Datei hochladen unter `Plugins → Neu hinzufügen → Plugin hochladen`
2. Plugin aktivieren
3. Globale Fragen definieren unter `Einstellungen → Quiz Spam Protection`

## Verwendung

### Globale Fragen definieren

1. Gehe zu `Einstellungen → Quiz Spam Protection`
2. Füge 3-10 Quiz-Fragen hinzu
3. Speichern

**Tipps für gute Fragen:**
- Einfache Fragen, die jeder beantworten kann
- Keine komplizierten Rechenaufgaben
- Eindeutige Antworten (z.B. "blau" statt "himmelblau")
- Groß-/Kleinschreibung wird automatisch ignoriert

### In Elementor Forms verwenden

1. Bearbeite ein Formular mit Elementor
2. Füge ein neues Feld hinzu
3. Wähle "Quiz Spam Protection" als Feldtyp
4. Wähle "Globale Fragen" oder "Eigene Fragen"
5. Fertig!

## Optionen im Widget

| Option | Beschreibung |
|--------|-------------|
| Fragenquelle | Global oder eigene Fragen |
| Eigene Fragen | Repeater für formular-spezifische Fragen |
| Fehlermeldung | Text bei falscher Antwort |

## Wie funktioniert die Sicherheit?

1. **Zufällige Auswahl**: Bei jedem Seitenaufruf wird eine zufällige Frage angezeigt
2. **Hash-basierte Validierung**: Die korrekte Antwort wird als Hash gespeichert
3. **Zeitlimit**: Der Hash ist nur 30 Minuten gültig (gegen Replay-Attacken)
4. **Server-seitige Prüfung**: Validierung erfolgt komplett auf dem Server

## Anforderungen

- WordPress 5.8+
- PHP 7.4+
- Elementor Pro (mit Forms-Modul)

## Changelog

### 1.0.0
- Initiale Version
- Globale und lokale Fragen-Verwaltung
- Hash-basierte sichere Validierung
- Native Elementor-Integration

## Lizenz

GPL v2 or later
