/**
 * Elementor Quiz Spam Protection - Admin JS
 */

(function($) {
    'use strict';

    const EQSP_Admin = {
        maxQuestions: 10,
        
        init: function() {
            this.bindEvents();
            this.updateCount();
        },

        bindEvents: function() {
            $('#eqsp-add-question').on('click', this.addQuestion.bind(this));
            $(document).on('click', '.eqsp-remove-question', this.removeQuestion.bind(this));
        },

        addQuestion: function(e) {
            e.preventDefault();
            
            const currentCount = this.getCount();
            if (currentCount >= this.maxQuestions) {
                return;
            }

            const template = $('#eqsp-question-template').html();
            const newIndex = this.getNextIndex();
            const newNumber = currentCount + 1;
            
            const newRow = template
                .replace(/\{\{INDEX\}\}/g, newIndex)
                .replace(/\{\{NUMBER\}\}/g, newNumber);
            
            const $newRow = $(newRow);
            $newRow.addClass('eqsp-new');
            
            $('#eqsp-questions-list').append($newRow);
            
            // Focus auf das Frage-Feld
            $newRow.find('input').first().focus();
            
            // Animation entfernen nach Abschluss
            setTimeout(() => {
                $newRow.removeClass('eqsp-new');
            }, 300);
            
            this.updateCount();
            this.updateButtonState();
        },

        removeQuestion: function(e) {
            e.preventDefault();
            
            const $row = $(e.currentTarget).closest('.eqsp-question-row');
            
            // Mindestens 1 Frage behalten
            if (this.getCount() <= 1) {
                alert('Mindestens eine Frage muss vorhanden sein.');
                return;
            }
            
            $row.addClass('eqsp-removing');
            
            setTimeout(() => {
                $row.remove();
                this.renumberQuestions();
                this.updateCount();
                this.updateButtonState();
            }, 200);
        },

        renumberQuestions: function() {
            $('#eqsp-questions-list .eqsp-question-row').each(function(idx) {
                $(this).find('.eqsp-question-number').text(idx + 1);
            });
        },

        getCount: function() {
            return $('#eqsp-questions-list .eqsp-question-row').length;
        },

        getNextIndex: function() {
            let maxIndex = -1;
            $('#eqsp-questions-list .eqsp-question-row').each(function() {
                const index = parseInt($(this).data('index'), 10);
                if (index > maxIndex) {
                    maxIndex = index;
                }
            });
            return maxIndex + 1;
        },

        updateCount: function() {
            $('#eqsp-count').text(this.getCount());
        },

        updateButtonState: function() {
            const $btn = $('#eqsp-add-question');
            if (this.getCount() >= this.maxQuestions) {
                $btn.prop('disabled', true);
            } else {
                $btn.prop('disabled', false);
            }
        }
    };

    $(document).ready(function() {
        EQSP_Admin.init();
    });

})(jQuery);
