<?php
/**
 * Elementor Quiz Form Field
 */

if (!defined('ABSPATH')) {
    exit;
}

class EQSP_Elementor_Quiz_Field extends \ElementorPro\Modules\Forms\Fields\Field_Base {

    public function get_type() {
        return 'quiz_spam';
    }

    public function get_name() {
        return __('Quiz Spam Protection', 'eq-spam-protection');
    }

    /**
     * Controls im Elementor Panel
     */
    public function update_controls($widget) {
        $elementor = \Elementor\Plugin::instance();
        $control_data = $elementor->controls_manager->get_control_from_stack(
            $widget->get_unique_name(),
            'form_fields'
        );

        if (is_wp_error($control_data)) {
            return;
        }

        // Fragenquelle: Global oder Custom
        $field_controls = [
            'quiz_source' => [
                'name' => 'quiz_source',
                'label' => __('Fragenquelle', 'eq-spam-protection'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'global',
                'options' => [
                    'global' => __('Globale Fragen', 'eq-spam-protection'),
                    'custom' => __('Eigene Fragen', 'eq-spam-protection'),
                ],
                'condition' => [
                    'field_type' => $this->get_type(),
                ],
                'tab' => 'content',
                'inner_tab' => 'form_fields_content_tab',
                'tabs_wrapper' => 'form_fields_tabs',
            ],
            'quiz_global_info' => [
                'name' => 'quiz_global_info',
                'type' => \Elementor\Controls_Manager::RAW_HTML,
                'raw' => sprintf(
                    '<div style="padding:10px;background:#f0f0f0;border-radius:4px;">%s <a href="%s" target="_blank">%s</a></div>',
                    __('Fragen werden aus den globalen Einstellungen geladen.', 'eq-spam-protection'),
                    admin_url('options-general.php?page=eqsp-settings'),
                    __('Fragen bearbeiten →', 'eq-spam-protection')
                ),
                'condition' => [
                    'field_type' => $this->get_type(),
                    'quiz_source' => 'global',
                ],
                'tab' => 'content',
                'inner_tab' => 'form_fields_content_tab',
                'tabs_wrapper' => 'form_fields_tabs',
            ],
            'quiz_custom_questions' => [
                'name' => 'quiz_custom_questions',
                'label' => __('Eigene Fragen', 'eq-spam-protection'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'question',
                        'label' => __('Frage', 'eq-spam-protection'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'placeholder' => __('z.B. Wieviel ist 2 + 3?', 'eq-spam-protection'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'answer',
                        'label' => __('Antwort', 'eq-spam-protection'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'placeholder' => __('z.B. 5', 'eq-spam-protection'),
                    ],
                ],
                'default' => [
                    [
                        'question' => 'Wieviel ist 2 + 3?',
                        'answer' => '5',
                    ],
                ],
                'title_field' => '{{{ question }}}',
                'condition' => [
                    'field_type' => $this->get_type(),
                    'quiz_source' => 'custom',
                ],
                'tab' => 'content',
                'inner_tab' => 'form_fields_content_tab',
                'tabs_wrapper' => 'form_fields_tabs',
            ],
            'quiz_error_message' => [
                'name' => 'quiz_error_message',
                'label' => __('Fehlermeldung', 'eq-spam-protection'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Die Antwort auf die Sicherheitsfrage ist falsch.', 'eq-spam-protection'),
                'placeholder' => __('Fehlermeldung bei falscher Antwort', 'eq-spam-protection'),
                'label_block' => true,
                'condition' => [
                    'field_type' => $this->get_type(),
                ],
                'tab' => 'content',
                'inner_tab' => 'form_fields_content_tab',
                'tabs_wrapper' => 'form_fields_tabs',
            ],
        ];

        // Controls zum Stack hinzufügen
        foreach ($field_controls as $field_control) {
            $control_data['fields'][$field_control['name']] = $field_control;
        }

        $widget->update_control('form_fields', $control_data);
    }

    /**
     * Field im Frontend rendern
     */
    public function render($item, $item_index, $form) {
        // Fragen laden (global oder custom)
        $questions = $this->get_questions($item);
        
        if (empty($questions)) {
            echo '<span class="elementor-field-textual">';
            echo '<em>' . esc_html__('Keine Quiz-Fragen konfiguriert.', 'eq-spam-protection') . '</em>';
            echo '</span>';
            return;
        }

        // Zufällige Frage auswählen
        $random_index = array_rand($questions);
        $selected_question = $questions[$random_index];
        
        // Hash für sichere Validierung erstellen
        $answer_hash = wp_hash(strtolower(trim($selected_question['answer'])));
        $validation_hash = base64_encode($random_index . '|' . $answer_hash . '|' . time());

        // Field ID und Name manuell bauen
        $field_id = $item['custom_id'];
        $field_name = 'form_fields[' . $field_id . ']';
        $input_id = 'form-field-' . $field_id;
        
        // CSS Klassen
        $input_class = 'elementor-field elementor-field-textual elementor-size-' . $item['input_size'];

        // HTML ausgeben
        ?>
        <span class="eqsp-quiz-question" style="display:block; margin-bottom:8px; font-weight:500;">
            <?php echo esc_html($selected_question['question']); ?>
        </span>
        <input 
            type="text" 
            name="<?php echo esc_attr($field_name); ?>" 
            id="<?php echo esc_attr($input_id); ?>" 
            class="<?php echo esc_attr($input_class); ?>"
            placeholder="<?php echo esc_attr(isset($item['placeholder']) ? $item['placeholder'] : ''); ?>"
            autocomplete="off"
            <?php echo !empty($item['required']) ? 'required="required" aria-required="true"' : ''; ?>
        >
        <input type="hidden" name="form_fields[<?php echo esc_attr($field_id); ?>_hash]" value="<?php echo esc_attr($validation_hash); ?>">
        <?php
    }

    /**
     * Fragen laden
     */
    private function get_questions($item) {
        $source = isset($item['quiz_source']) ? $item['quiz_source'] : 'global';
        
        if ($source === 'custom' && !empty($item['quiz_custom_questions'])) {
            $questions = [];
            foreach ($item['quiz_custom_questions'] as $q) {
                if (!empty($q['question']) && !empty($q['answer'])) {
                    $questions[] = [
                        'question' => $q['question'],
                        'answer' => $q['answer'],
                    ];
                }
            }
            if (!empty($questions)) {
                return $questions;
            }
        }
        
        // Fallback auf globale Fragen
        return EQSP_Admin_Settings::get_global_questions();
    }

    /**
     * Validierung
     */
    public function validation($field, $record, $ajax_handler) {
        // Validierung passiert in der Hauptklasse
    }
}
