<?php
/*
Plugin Name: Simple Comment Mover Pro
Description: Verschiebe genehmigte Kommentare einfach zwischen Beiträgen oder Seiten mit korrekter Aktualisierung der Kommentaranzahl.
Version: 4.0
Author: fastWP
Author URI: https://fastwp.de
*/

// Admin-Menü hinzufügen
add_action('admin_menu', 'scmp_admin_menu');
function scmp_admin_menu() {
    add_menu_page(
        'Kommentare verschieben',
        'Kommentare verschieben',
        'manage_options',
        'simple-comment-mover-pro',
        'scmp_admin_page',
        'dashicons-admin-comments',
        80
    );
}

// Kommentaranzahl holen
function scmp_get_comment_count($post_id) {
    global $wpdb;
    return (int) $wpdb->get_var($wpdb->prepare(
        "SELECT COUNT(*) FROM {$wpdb->comments} WHERE comment_post_ID = %d AND comment_approved = '1'",
        $post_id
    ));
}

// Admin-Seite rendern
function scmp_admin_page() {
    global $wpdb;

    $post_type = isset($_POST['post_type']) ? sanitize_text_field($_POST['post_type']) : 'page';

    if (isset($_POST['scmp_submit'])) {
        $source_post = intval($_POST['source_post']);
        $target_post = intval($_POST['target_post']);

        if ($source_post === 0 || $target_post === 0 || $source_post === $target_post) {
            echo '<div class="notice notice-error"><p>Bitte zwei unterschiedliche Elemente auswählen.</p></div>';
        } else {
            // Nur genehmigte Kommentare auswählen
            $comments = $wpdb->get_results($wpdb->prepare(
                "SELECT comment_ID FROM {$wpdb->comments} WHERE comment_post_ID = %d AND comment_approved = '1'",
                $source_post
            ));

            if (!empty($comments)) {
                $comment_ids = wp_list_pluck($comments, 'comment_ID');
                $ids_placeholder = implode(',', array_fill(0, count($comment_ids), '%d'));

                // Kommentare verschieben
                $updated = $wpdb->query($wpdb->prepare(
                    "UPDATE {$wpdb->comments} SET comment_post_ID = %d WHERE comment_ID IN ($ids_placeholder)",
                    array_merge([$target_post], $comment_ids)
                ));

                if ($updated !== false) {
                    // Kommentarzähler aktualisieren
                    wp_update_comment_count($source_post);
                    wp_update_comment_count($target_post);

                    echo '<div class="notice notice-success"><p>' . esc_html($updated) . ' Kommentar(e) erfolgreich verschoben und Zähler aktualisiert.</p></div>';
                } else {
                    echo '<div class="notice notice-error"><p>Fehler beim Verschieben der Kommentare.</p></div>';
                }
            } else {
                echo '<div class="notice notice-error"><p>Keine genehmigten Kommentare gefunden.</p></div>';
            }
        }
    }

    // Beiträge oder Seiten laden
    $items = get_posts([
        'post_type' => $post_type,
        'posts_per_page' => -1,
        'orderby' => 'title',
        'order' => 'ASC'
    ]);
    ?>

    <div class="wrap">
        <h2>Kommentare verschieben (Beiträge oder Seiten)</h2>

        <form method="post">
            <table class="form-table">
                <tr>
                    <th>Typ wählen:</th>
                    <td>
                        <select name="post_type" onchange="this.form.submit()">
                            <option value="page" <?= selected($post_type, 'page'); ?>>Seiten</option>
                            <option value="post" <?= selected($post_type, 'post'); ?>>Beiträge</option>
                        </select>
                    </td>
                </tr>
            </table>
        </form>

        <form method="post">
            <input type="hidden" name="post_type" value="<?= esc_attr($post_type); ?>">
            <table class="form-table">
                <tr>
                    <th>Kommentare von:</th>
                    <td>
                        <select name="source_post" required>
                            <option value="0">– wählen –</option>
                            <?php foreach ($items as $item):
                                $count = scmp_get_comment_count($item->ID); ?>
                                <option value="<?= esc_attr($item->ID); ?>">
                                    <?= esc_html($item->post_title . " ({$count} Kommentare)"); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </td>
                </tr>
                <tr>
                    <th>Kommentare verschieben zu:</th>
                    <td>
                        <select name="target_post" required>
                            <option value="0">– wählen –</option>
                            <?php foreach ($items as $item):
                                $count = scmp_get_comment_count($item->ID); ?>
                                <option value="<?= esc_attr($item->ID); ?>">
                                    <?= esc_html($item->post_title . " ({$count} Kommentare)"); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </td>
                </tr>
            </table>
            <?php submit_button('Kommentare verschieben', 'primary', 'scmp_submit'); ?>
        </form>
    </div>
    <?php
}

