<?php
if (!defined('ABSPATH')) exit;

function wortzaehler_buffer_callback($content) {
    // Nur für eingeloggte Nutzer
    if (is_admin() || is_feed() || !is_user_logged_in()) {
        return $content;
    }

    $text = strip_tags($content);
    $text = preg_replace('/\s+/', ' ', trim($text));

    $word_count = 0;
    $char_count = 0;
    
    if (!empty($text)) {
        preg_match_all('/\p{L}+/u', $text, $matches);
        $word_count = count($matches[0]);
        $char_count = mb_strlen(preg_replace('/\s+/', '', $text));
    }

    $output = '<div class="wortzaehler-container" style="padding:15px; margin:15px 0; background:#f3f4f6; border:1px solid #e5e7eb; border-radius:8px;">
        <div style="display:flex; gap:25px; font-size:0.9em;">
            <div>📝 <strong>Wörter:</strong> '.number_format($word_count, 0, ',', '.').'</div>
            <div>🔢 <strong>Zeichen:</strong> '.number_format($char_count, 0, ',', '.').'</div>
        </div>
    </div>';

    // Füge die Anzeige AM ANFANG des Contents ein
    return $output.$content;
}

add_filter('the_content', 'wortzaehler_buffer_callback', 999);